<?php
class usuariosModel extends Db
{
    public $IdUsuario;
    public $Usuario;
    public $Correo;
    public $Telefono;
    public $Departamento;
    public $NombreUsuario;
    public $Contra;
    public $activo;

    /**
     * 
     * Metodo para agregar nuevo usuario
     * @return integer 
     */

    public function add()
    {

        $haspassword = filter_var($this->Contra, FILTER_SANITIZE_STRING);
        $p_hashed = password_hash($haspassword, PASSWORD_BCRYPT);
        $sql = "INSERT INTO usuarios (Usuario,Correo,Telefono,Departamento,NombreUsuario,Contra) VALUES (:Usuario,:Correo,:Telefono,:Departamento,:NombreUsuario,:Contra)";

        $data =
            [
                'Usuario' => $this->Usuario,
                'Correo' => $this->Correo,
                'Telefono' => $this->Telefono,
                'Departamento' => $this->Departamento,
                'NombreUsuario' => $this->NombreUsuario,
                'Contra' => $p_hashed
            ];

        try {
            return ($this->IdUsuario = parent::query($sql, $data)) ? $this->IdUsuario : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para cargar todos los usuarios
     * @return void 
     */

    public function all()
    {
        $sql = "SELECT * FROM usuarios ORDER BY IdUsuario";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
    /**
     * 
     * Metodo para cargar un registro usando su id
     * @return void 
     */

    public function one()
    {
        $sql = "SELECT * FROM usuarios WHERE IdUsuario=:IdUsuario LIMIT 1";
        try {
            return ($rows = parent::query($sql, ['IdUsuario' => $this->IdUsuario])) ? $rows[0] : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return bool 
     */

    public function update()
    {

        if ($this->Contra != '') {
            $haspassword = filter_var($this->Contra, FILTER_SANITIZE_STRING);
            $p_hashed = password_hash($haspassword, PASSWORD_BCRYPT);
            $sql = "UPDATE usuarios SET Telefono=:Telefono, Departamento=:Departamento, Contra=:Contra WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Telefono' => $this->Telefono,
                    'Departamento' => $this->Departamento,
                    'Contra' => $p_hashed,
                    'IdUsuario' => $this->IdUsuario
                ];
        } else {
            $sql = "UPDATE  usuarios SET Telefono=:Telefono, Departamento=:Departamento WHERE IdUsuario=:IdUsuario";
            $data =
                [
                    'Telefono' => $this->Telefono,
                    'Departamento' => $this->Departamento,
                    'IdUsuario' => $this->IdUsuario
                ];
        }
        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * 
     * Metodo para actualizar un registro de la bd
     * @return void 
     */

    public function delete()
    {
        $sql = "DELETE FROM usuarios WHERE IdUsuario=:IdUsuario LIMIT 1";

        $data =
            [
                'IdUsuario' => $this->IdUsuario
            ];

        try {
            return (parent::query($sql, $data)) ? true : false;
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function departamento(){
        $sql = "SELECT * FROM departamentos";
        try {
            return ($rows = parent::query($sql)) ? $rows : false;
        } catch (Exception $e) {
            throw $e;
        }
    }
}
